//###########################################################
//#															#
//#	File:			CDEV.r									#
//#	Version:		3.0										#
//#	Author:													#
//#	Copyright:		(c) 1989-1990 by Apple Computer, Inc.	#
//#	Developer Technical Support Apple II Sample Code		#
//#															#
//#	Description:	This file contains the resource			#
//#					definitions used by the Shell CDEV		#
//#															#
//#---------------------------------------------------------#
//#															#
//#	Development History:									#
//#															#
//#	Who		Date		The Modification					#
//#	---		--------	----------------					#
//#															#
//###########################################################

//###########################################################
//#		Read any standard includes & define our own			#
//###########################################################

#include "typesiigs.r"	//	include the type definitions

#define	AboutID		0x1000

#define PopUpList	$5000
#define PopUp1		$5001
#define PopUp2		$5002
#define	PopUp3		$5003
#define PopUp1Item1	$5101
#define PopUp1Item2	$5102
#define PopUp1Item3	$5103
#define	PopUp1Item4	$5104
#define PopUp2Item1 $5201
#define PopUp2Item2 $5202
#define PopUp2Item3 $5203
#define	PopUp3Item1	$5301
#define	PopUp3Item2	$5302

//###########################################################
//#		Read the resources built elsewhere					#
//###########################################################

read rCDEVCode (1, Convert) "CDevCode";	// this is the code resource

//###########################################################
//#		Define our resources								#
//###########################################################

resource rCDEVFlags (1) {
	wantHit+wantInit+wantCreate+wantAbout+canBeInactive,	// CDEV flags
	1,								//	enabled = True
	1,								//	Version = 1
	1,								//	Machine = v1 ROMs or higher
	5,								//	System = v5.0 or higher
	{0,0,47,200},					//	DataRect - top left MUST be 0,0
	"CDev",							//	Name
	"Your Name Here",				//	Author
	"v3.0";							//	Version String
};

//###########################################################
//#		Define About Box resources							#
//###########################################################

resource rControlTemplate (AboutID) {
	AboutID,						//	control ID
	{38,5,128,280},					//	rect
	statTextControl {{
		0,							//	flags
		0b0001000000000010,			//	more flags
		0,							//	refCon
		AboutID
	}},
};

resource rTextForLETextBox2 (AboutID) {
	"This CDEV shows how easy it is to create a CDEV on the Apple IIgs."
};

//###########################################################
//#		Define menu resources								#
//###########################################################

resource rControlList (PopUpList) {
	{
		PopUp1,
		PopUp2,
		PopUp3
	}
};
resource rControlTemplate (PopUp1) {
	PopUp1,							//	control ID
	{2,5,14,195},					//	rect
	PopUpControl {{
		fType2PopUp,				//	flags
		fCtlProcNotPtr+RefIsResource,	//	more flags
		0,							//	refcon
		80,							//	title width
		PopUp1,						//	resource ID for menu template
		PopUp1Item1					//	Initial value
	}},
};

resource rMenu (PopUp1)	{
	PopUp1,																	/* id of menu */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,	/* menu flags */
	PopUp1,																	/* id of title string */
	{ PopUp1Item1,PopUp1Item2,PopUp1Item3, PopUp1Item4 };					/* id's of items */
};

resource rPString (PopUp1) {
	" Item 1: "
};


resource rMenuItem (PopUp1Item1)	{
	PopUp1Item1,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp1Item1
};
resource rPString (PopUp1Item1) {
	" Impressive! "
};


resource rMenuItem (PopUp1Item2)	{
	PopUp1Item2,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp1Item2
};
resource rPString (PopUp1Item2) {
	" Elegant! "
};


resource rMenuItem (PopUp1Item3)	{
	PopUp1Item3,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp1Item3
};
resource rPString (PopUp1Item3) {
	" Amazing! "
};

resource rMenuItem (PopUp1Item4)	{
	PopUp1Item4,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp1Item4
};
resource rPString (PopUp1Item4) {
	" Stupendous! "
};

//--------------------------------------------------------------------------------------------------

resource rControlTemplate (PopUp2) {
	PopUp2,							//	control ID
	{17,5,29,195},					//	rect
	PopUpControl {{
		fType2PopUp,				//	flags
		fCtlProcNotPtr+RefIsResource,	//	more flags
		0,							//	refcon
		80,							//	title width
		PopUp2,						//	resource ID for menu template
		PopUp2Item1					//	Initial value
	}},
};

resource rMenu (PopUp2)	{
	PopUp2,																	/* id of menu */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,	/* menu flags */
	PopUp2,																	/* id of title string */
	{ PopUp2Item1,PopUp2Item2,PopUp2Item3 };								/* id's of items */
};

resource rPString (PopUp2) {
	" Item 2: "
};


resource rMenuItem (PopUp2Item1)	{
	PopUp2Item1,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp2Item1
};
resource rPString (PopUp2Item1) {
	" Wow! "
};


resource rMenuItem (PopUp2Item2)	{
	PopUp2Item2,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp2Item2
};
resource rPString (PopUp2Item2) {
	" Golly! "
};


resource rMenuItem (PopUp2Item3)	{
	PopUp2Item3,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp2Item3
};
resource rPString (PopUp2Item3) {
	" Holy Cow! "
};

//--------------------------------------------------------------------------------------------------

resource rControlTemplate (PopUp3) {
	PopUp3,							//	control ID
	{32,5,44,195},					//	rect
	PopUpControl {{
		fType2PopUp,				//	flags
		fCtlProcNotPtr+RefIsResource,	//	more flags
		0,							//	refcon
		80,							//	title width
		PopUp3,						//	resource ID for menu template
		PopUp3Item1					//	Initial value
	}},
};

resource rMenu (PopUp3)	{
	PopUp3,																	/* id of menu */
	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,	/* menu flags */
	PopUp3,																	/* id of title string */
	{ PopUp3Item1,PopUp3Item2 };											/* id's of items */
};

resource rPString (PopUp3) {
	" Item 3: "
};


resource rMenuItem (PopUp3Item1)	{
	PopUp3Item1,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp3Item1
};
resource rPString (PopUp3Item1) {
	" Too Hip! "
};


resource rMenuItem (PopUp3Item2)	{
	PopUp3Item2,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fXOR,
	PopUp3Item2
};
resource rPString (PopUp3Item2) {
	" That's All! "
};

//###########################################################
//#		Define icon resources								#
//###########################################################

resource rIcon (1) {				//	the "CDEV" icon
	0x8000,							//	kind
	20,								//	height
	28,								//	width
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FF7777FF11111FFBBBBBFDDFFDDF"
	$"F777777F111111FBBBBBFDDFFDDF"
	$"F77FF77F11FF11FBBFFFFDDFFDDF"
	$"F77FFFFF11FF11FBBBBFFDDFFDDF"
	$"F77FFFFF11FF11FBBBBFFDDFFDDF"
	$"F77FF77F11FF11FBBFFFFDDFFDDF"
	$"F777777F111111FBBBBBFFDDDDFF"
	$"FF7777FF11111FFBBBBBFFFDDFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF"
	$"FFFFFFFFFFFFFFFFFFFFFFFFFFFF",
	
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"00FFFF00FFFFF00FFFFF0FF00FF0"
	$"0FFFFFF0FFFFFF0FFFFF0FF00FF0"
	$"0FF00FF0FF00FF0FF0000FF00FF0"
	$"0FF00000FF00FF0FFFF00FF00FF0"
	$"0FF00000FF00FF0FFFF00FF00FF0"
	$"0FF00FF0FF00FF0FF0000FF00FF0"
	$"0FFFFFF0FFFFFF0FFFFF00FFFF00"
	$"00FFFF00FFFFF00FFFFF000FF000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
	$"0000000000000000000000000000"
};